# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Module/Manifest/Skip.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/ParseLink.pm) perl(Pod/Parser.pm) perl(Pod/Text.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(namespace/autoclean.pm) perl(parent.pm) perl(Catalyst/Model/Factory/PerRequest.pm)
# END SourceDeps(oneline)
%define module_version 0.002
%define module_name Catalyst-Model-WebService-MyGengo
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Catalyst Model providing access to the L<WebService::MyGengo> library
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/N/NH/NHEINRIC/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
In your model class:.
    package MyApp::Model::MyGengo;
    
    use strict;
    use parent qw( Catalyst::Model::WebService::MyGengo );
    
    __PACKAGE__->config({
        class           => 'WebService::MyGengo::Client'
        , public_key    => 'your API public key'
        , private_key   => 'your API private key'
        , use_sandbox   => 0    # Whether to use the production site or the sandbox
        # See WebService::MyGengo::Client for other options
        });
    
    1;

Or in your myapp.conf or myapp_local.conf file ( be sure to escape any #
characters in your keys (eg \#) ):

    <Model::MyGengo>
        class           WebService::MyGengo::Client
        public_key      my-sandbox-pubkey
        private_key     my-sandbox-privkey
        use_sandbox     1
    </Model::MyGengo>

Then, in a controller:

    # Grab a WebService::MyGengo::Job
    my $job = $c->model('MyGengo')->get_job( 123 );

    # Add comments, etc.
    $job = $c->model('MyGengo')->add_job_comment( $job, "Nicey nice nice!" );


%prep
%setup -n nheinric-Catalyst--Model--WebService--MyGengo-5fcbb04

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.mkdn
%perl_vendor_privlib/C*

%changelog
