# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Catalyst-Plugin-AutoRestart
%define upstream_version 0.96

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_12

Summary:    Catalyst plugin to restart server 
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Catalyst/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Catalyst.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(inc/Module/Install.pm)
BuildRequires: perl(MRO/Compat.pm)
BuildRequires: perl(Proc/ProcessTable.pm)
BuildRequires: perl(Text/SimpleTable.pm)
BuildArch:  noarch
Source44: import.info

%description
Catalyst plugin to force the application to restart server processes when
they reach a configurable memory threshold. Memory checks are performed
every 'N' requests. This is intended as a band-aid to deal with problems
like memory leaks; it's here to buy you time to find and solve the
underlying issues.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml  README
%perl_vendor_privlib/*


%changelog
