# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(MIME/Base64.pm) perl(Test/Exception.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Catalyst-Plugin-BootstrapAlert
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.50
Release: alt1
Summary: Replacement for Catalyst::Plugin::StatusMessage inline with Bootstrap alert names (success, info, w...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CA/CAGAO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Replacement for Catalyst::Plugin::StatusMessage using Bootstrap alert names (success, info, warning, and danger),
whilst also keeping `status_msg' and `error_msg' as aliases.

Storing an array-ref of msgs, or even an array-ref of hash-refs is fine, in TT you'd want to use the `list' VMethod:

    [%% IF danger_alert.list.size %%]
                        <div class="alert alert-danger" role="alert">
        [%% FOREACH each_danger_alert IN danger_alert.list %%]
                            <p>[%% each_danger_alert %%]</p>
        [%% END %%]
                        </div>
    [%% END %%]

Calling `list' on an actual list just returns the list, so essentially a no-op.

See http://www.template-toolkit.org/docs/manual/VMethods.html#section_list

In MyApp.pm:

    use Catalyst qr/
        BootstrapAlert
    /;

In controller where you want to save a message for display on the next page:

   $c->response->redirect( "/?mid=" . $c->set_success_alert("It worked!") );

Or, to save an danger message:

   $c->response->redirect( "/?mid=" . $c->set_error_msg("Error deleting widget") );

Then, in the controller action that corresponds to the redirect above:

    sub list :Path {
        my ($self, $c) = @_;
        ...
        $c->load_bootstrap_alerts;
        ...
    }

This would mean simply changing `load_status_msgs' if using `Catalyst::Plugin::StatusMessage'.

And, to display the output (here using Template Toolkit):

    ...
    <span class="message">[%% success_alert %%]</span>
    <span class="error">[%% error_msg %%]</span>
    ...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
