%define module_name Catalyst-Plugin-CachedUriForAction
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Meta.pm) perl(Catalyst.pm) perl(Pod/Readme/Brief.pm) perl(Software/LicenseUtils.pm) perl(Test/More.pm) perl(URI.pm) perl(URI/Encode/XS.pm) perl(mro.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.003
Release: alt1
Summary: drop-in supercharger for uri_for_action
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AR/ARISTOTLE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This provides a (mostly) drop-in replacement version of `uri_for_action'.

The stock Catalyst `uri_for_action' method is a thin wrapper around `uri_for'.
Every time you pass `uri_for' an action to create a parametrized URL for it, it introspects the dispatcher.
This is expensive, and on views that generate a lot of URLs, it can add up to a substantial cost.
Doing this introspection repeatedly can only possibly be useful if the set of controllers and actions in the application can change at runtime.
Even then it is still wasted time on any view that generates many URLs for the same action.

This plugin scans the dispatch table once during startup and pregenerates templates for all possible output URLs.
The only work then left in `uri_for_action' is the string manipulation to assemble a URL from its template.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/C*

%changelog
