%define module_name Catalyst-Plugin-EnvironmentDetector
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Sys/Hostname.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt2
Summary: Catalyst plugin for environment detection
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KK/KKANE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin is intended to provide a generic way to detect what environment your
catalyst instance is currently operating in.  This is good for when you need/want
to modify behavior depending on the context that you are running the instance in.

This is done in a generic way so if the nature of the environment ever changes
you can simply update the config and it will work rather than propagating the
change to every place in your code you may have needed to detect environments.

Why would you want to do this?:
    Changing the authentication behavior in test or development
    Changing email recipients for test or development
    Circumventing security policies in a dedicated test environment

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
