# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catalyst.pm) perl(Catalyst/Controller.pm) perl(Catalyst/Runtime.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Path/Class.pm) perl(Test/More.pm) perl(Test/Strict.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Catalyst-Plugin-Mode
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: select config values depends in your development process
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PL/PLCGI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Only include the plugin in your main app module
Sometimes you need any values for your environment(development,test,predproduction,production)


For example in development you use such urls as
http://you_url


in test
http://test_domain.you_url/path


in production
http://prod_domain.you_url/blabla


You can manage this process with the plugin - in configuration only, without any calling methods
describe some options in your config such way


in .yml

    Catalyst::Plugin::Mode:
        keys:
            - any
            - another
        mode: test    
    any:
        dev:
            one_url: http://dev_one_url
            two_url: http://dev_two_url
        test:
            one_url: http://test_one_url
            two_url: http://test_two_url
        prod: 
            one_url: http://prod_one_url
            two_url: http://prod_two_url
    another:
        dev:
            one_url: http://any_another_dev_one_url
            two_url: http://any_another_dev_two_url
        test:
            one_url: http://any_another_test_one_url
            two_url: http://any_another_test_two_url
        prod:
            one_url: http://any_another_prod_one_url
            two_url: http://any_another_prod_two_url


in perl


    __YOUR_APPLICATION__->config({
        'Catalyst::Plugin::Mode' => {
            keys => [qw/any any.else any.any.another/],
            mode => 'test'
        },
        any => {
            dev => {
                one_url => 'http://dev_one_url',
                two_url => 'http://dev_two_url'
            },    
            test => {
                one_url => 'http://test_one_url',
                two_url => 'http://test_two_url'
            }    
            prod => {
                one_url => 'http://prod_one_url',
                two_url => 'http://prod_two_url'
            },
        another => {
            dev => {
                one_url => 'http://any_another_dev_one_url',
                two_url => 'http://any_another_dev_two_url'
            },    
            test => {
                one_url => 'http://any_another_test_one_url',
                two_url => 'http://any_another_test_two_url'
            }    
            prod => {
                one_url => 'http://any_another_prod_one_url',
                two_url => 'http://any_another_prod_two_url'
            },
        }
    });


When you run your catalyst app, setup parse config and will be


    any => {
        one_url => 'http://test_one_url',
        two_url => 'http://test_two_url'
    another => {
        one_url => 'http://any_another_test_one_url',
        two_url => 'http://any_another_test_two_url'
    }


In such way you can change only one value in your config - `mode' and all urls will be as you need
You can define valid valuev for mode for your application to ENV{APPLICATION_MODE}
All examples in tests


Available options for `mode':  dev|test|pred|prod



%prep
%setup -n %module_name-0.02

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes.gz README
%perl_vendor_privlib/C*

%changelog
