# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Catalyst/Runtime.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(Moose/Role.pm) perl(Plack.pm) perl(Prometheus/Tiny.pm) perl(Prometheus/Tiny/Shared.pm) perl(Scalar/Util.pm) perl(Sub/Override.pm) perl(Test/Deep.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Catalyst-Plugin-PrometheusTiny
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: Prometheus metrics for Catalyst
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SY/SYSPETE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin integrates the Prometheus::Tiny::Shared manpage with your the Catalyst manpage app,
providing some default metrics for requests and responses, with the ability
to easily add further metrics to your app. A default controller is included
which makes the metrics available via the configured the endpoint entry elsewhere in this document, though this
can be disabled if you prefer to add your own controller action.

See the Prometheus::Tiny manpage for more details of the kind of metrics supported.

The following metrics are included by default:

    http_request_duration_seconds => {
        help => 'Request durations in seconds',
        type => 'histogram',
    },
    http_request_size_bytes => {
        help    => 'Request sizes in bytes',
        type    => 'histogram',
        buckets => [ 1, 50, 100, 1_000, 50_000, 500_000, 1_000_000 ],
    },
    http_requests_total => {
        help => 'Total number of http requests processed',
        type => 'counter',
    },
    http_response_size_bytes => {
        help    => 'Response sizes in bytes',
        type    => 'histogram',
        buckets => [ 1, 50, 100, 1_000, 50_000, 500_000, 1_000_000 ],
    }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/C*

%changelog
