# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Catalyst-Plugin-Session-Store-Memcached
%define upstream_version 0.05

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_11

Summary:    Memcached storage for Catalyst sessions
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Catalyst/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Cache/Memcached/Managed.pm)
BuildRequires: perl(Catalyst/ClassData.pm)
BuildRequires: perl(Catalyst/Plugin/Session.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(MRO/Compat.pm)
BuildRequires: perl(inc/Module/Install.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(MooseX/Emulate/Class/Accessor/Fast.pm)
BuildRequires: perl(namespace/clean.pm)
BuildRequires: perl(Class/Data/Inheritable.pm)
BuildArch:  noarch
Source44: import.info

%description
'Catalyst::Plugin::Session::Store::Memcached' is a session storage plugin
for Catalyst that uses the the Cache::Memcached::Managed manpage module to
connect to memcached, a fast data caching server.

METHODS
    * get_session_data

    * store_session_data

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml 
%perl_vendor_privlib/*


%changelog
