%define module_name CatalystX-I18N
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/pod2pdf.pm) perl(CPAN.pm) perl(Capture/Tiny.pm) perl(Catalyst/Plugin/Session.pm) perl(Catalyst/Plugin/Session/State/Cookie.pm) perl(Catalyst/Plugin/Session/Store/File.pm) perl(Catalyst/Runtime.pm) perl(Catalyst/View/TT.pm) perl(Clone.pm) perl(Data/Localize.pm) perl(Data/Localize/Format/Gettext.pm) perl(DateTime.pm) perl(DateTime/Format/CLDR.pm) perl(DateTime/Locale.pm) perl(DateTime/TimeZone.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/BrowserDetect.pm) perl(IO/All.pm) perl(IP/Country.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Locale/Geocode.pm) perl(Locale/Maketext.pm) perl(Locale/Maketext/Lexicon.pm) perl(Module/Build.pm) perl(Moose.pm) perl(MooseX/Types/DateTime.pm) perl(MooseX/Types/Path/Class.pm) perl(Net/FTP.pm) perl(Number/Format.pm) perl(POSIX.pm) perl(Parse/CPAN/Meta.pm)
BuildRequires: perl(Path/Class.pm) perl(Pod/Markdown.pm) perl(Pod/Usage.pm) perl(Template.pm) perl(Test/Most.pm) perl(Test/NoWarnings.pm) perl(Test/WWW/Mechanize/Catalyst.pm) perl(Unicode/Collate.pm) perl(YAML/Tiny.pm) perl(namespace/autoclean.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.14
Release: alt1
Summary: Catalyst internationalisation (I18N) framework
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MAROS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
CatalystX::I18N provides a comprehensive toolset for internationalisation 
(I18N) and localisation (L10N) of catalyst applications. This distribution 
consists of several modules that are designed to integrate seamlessly, but
can be run idependently or replaced easily if necessary.

=over

=item * the CatalystX::I18N::Role::Base manpage 

Basic I18N role that glues everything toghether.

=item * the CatalystX::I18N::Role::Maketext manpage 

Localize text via the Locale::Maketext manpage. Prefered over 
the CatalystX::I18N::Role::DataLocalize manpage

=item * the CatalystX::I18N::Role::DataLocalize manpage 

Localize text via the Data::Localize manpage. Alternative to 
the CatalystX::I18N::Role::Maketext manpage

=item * the CatalystX::I18N::Role::PosixLocale manpage 

Sets the POSIX locale

=item * the CatalystX::I18N::Role::DateTime manpage

Methods for localising date and time informations.

=item * the CatalystX::I18N::Role::NumberFormat manpage

Methods for localising numbers.

=item * the CatalystX::I18N::TraitFor::Request manpage

Extends the Catalyst::Request manpage with usefull methods to help dealing with
various I18N related information in HTTP requests.

=item * the CatalystX::I18N::TraitFor::Response manpage

Adds a `Content-Language' header to the response.

=item * the CatalystX::I18N::Role::GetLocale manpage 

Tries to determine the most appropriate locale for the current request.

=item * the CatalystX::I18N::Model::Maketext manpage

Provides access to the Locale::Maketext manpage classes via a Catalyst model.

=item * the CatalystX::I18N::Model::DataLocalize manpage

Provides access to a the Data::Localize manpage class via a Catalyst model.

=item * the CatalystX::I18N::Maketext manpage

Helpful wrapper around the Locale::Maketext manpage. Can also be used outside of 
Catalyst.

=item * the CatalystX::I18N::DataLocalize manpage

Helpful wrapper around the Data::Localize manpage. Can also be used outside of 
Catalyst.

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/C*

%changelog
