%define module_name CatalystX-RequestModel
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catalyst.pm) perl(Catalyst/Test.pm) perl(CatalystX/Errors.pm) perl(Class/Method/Modifiers.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(JSON/MaybeXS.pm) perl(Module/Pluggable/Object.pm) perl(Module/Runtime.pm) perl(Moo.pm) perl(Moose.pm) perl(MooseX/MethodAttributes.pm) perl(Scalar/Util.pm) perl(String/CamelCase.pm) perl(Test/Lib.pm) perl(Test/Most.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.020
Release: alt1
Summary: Map body and data parameters to a model
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/CatalystX-RequestModel

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Dealing with incoming POSTed (or PUTed/ PATCHed, etc) request content bodies is one of the most common
code issues we have to deal with.  the Catalyst manpage has generic capacities for handling common incoming
content types such as form URL encoded (common with HTML forms) and JSON as well as the ability to
add in parsing for other types of contents (see the Catalyst#DATA-HANDLERS entry elsewhere in this document).   However these parsers
only checked that a given body content is well formed and not that its valid for your given problem
domain.  Additionally I find that we spend a lot of code lines in controllers that are doing nothing
but munging and trying to wack incoming parameters into a form that can be actually used.

I've seen this approach of mapping incoming content bodies to models put to good use in frameworks
in other languages.  Mapping to a model gives you a clear place to do any data reformating you
need as well as the type of pre validation work we often perform in a controller.  Think of it as a
type of command class pattern subtype.  It promotes looser binding between your controller and your
applications models, and it makes for neater, smaller controllers as well as separating out the
types of work we do into smaller, more comprehendible classes.   Lastly we encapsulate some of the
more common types of issues into configuration (for example dealing with how HTML form POSTed
parameters can cause you issues when they are sometimes in array form) as well as improve security
by having an explict interface to the model.

Also once we have a model that defines an expected request, we should be able to build upon the meta data
it exposed to do things like auto generate Open API / JSON Schema definition files (TBD but possible).

Basically you convert an unknown hash of values into a well defined object.  This should reduce typo
induced errors at the very least.

The main downside here is the time you need to inflate the additional classes as well as some documentation
efforts needed to help...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/C*

%changelog
