%define module_name Catmandu-Blacklight
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catmandu.pm) perl(IO/Socket/SSL.pm) perl(JSON/MaybeXS.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Parser/MGC.pm) perl(REST/Client.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Simple.pm) perl(Throwable/Error.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Catmandu modules for working with Blacklight catalogs
Group: Development/Perl
License: perl
URL: https://github.com/LibreCat/Catmandu-Blacklight

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HO/HOCHSTEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
# From the command line
  $ catmandu convert Blacklight --url http://lib.ugent.be/catalog -q Schopenhauer
  
  # From Perl
  use Catmandu;

  my $importer = Catmandu->importer('Blacklight',
                      url => 'http://lib.ugent.be/catalog' , 
                      q   => 'Schopenhauer');

  $importer->each(sub {
_   my $item = shift;
_   print "%%s %%s\n", $item->{_id} , $item->{title}->[0];
  });


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/C*

%changelog
