# BEGIN SourceDeps(oneline):
BuildRequires: perl(CQL/Parser.pm) perl(Catmandu.pm) perl(Cpanel/JSON/XS.pm) perl(Module/Build.pm) perl(Moo.pm) perl(OpenSearch.pm) perl(Parser/MGC.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Throwable/Error.pm) perl(Types/Common/String.pm) perl(Types/Standard.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define module_name Catmandu-Store-OpenSearch
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: A searchable store backed by Opensearch
Group: Development/Perl
License: perl
URL: https://github.com/LibreCat/Catmandu-Store-OpenSearch

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NJ/NJFRANCK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
# From the command line

    # Import data into OpenSearch
    $ catmandu import JSON to OpenSearch --bag catmandu < data.json

    # Export data from OpenSearch
    $ catmandu export OpenSearch --bag catmandu to JSON > data.json

    # Export only one record
    $ catmandu export OpenSearch --bag catmandu --id 1234

    # Export using an OpenSearch query
    $ catmandu export OpenSearch --bag catmandu --query "name:Recruitment OR name:college"

    # Export using a CQL query (needs a CQL mapping)
    $ catmandu export OpenSearch --bag catmandu --cql-query "name any college"

    # From Perl

    use Catmandu;

    my $store = Catmandu->store('OpenSearch');

    my $obj1 = $store->bag('catmandu')->add({ name => 'Patrick' });

    printf "obj1 stored as %%s\n" , $obj1->{_id};

    # Force an id in the store
    my $obj2 = $store->bag('catmandu')->add({ _id => 'test123' , name => 'Nicolas' });

    # Commit all changes
    $store->bag('catmandu')->commit;

    $store->bag('catmandu')->delete('test123');

    $store->bag('catmandu')->delete_all;

    # All bags are iterators
    $store->bag->each(sub { ... });
    $store->bag->take(10)->each(sub { ... });

    # Query the store using a simple OpenSearch query
    my $hits = $store->bag->search(query => '(content:this OR name:this) AND (content:that OR name:that)');

    # Native queries are also supported by providing a hash of terms
    # See the OpenSearch manual for more examples
    my $hits = $store->bag->search(
        query => {
            # All name.exact fields that start with 'test'
            prefix => {
                'name.exact' => 'test'
            }
        } ,
        limit => 1000);

    # Catmandu::Store::OpenSearch supports CQL...
    my $hits = $store->bag->search(cql_query => 'name any "Patrick"');

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/C*

%changelog
