# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catmandu.pm) perl(Catmandu/Fix/Datahub.pm) perl(JSON.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Moo.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(XML/Struct.pm) perl(Throwable/Error.pm) perl(Parser/MGC.pm)
# END SourceDeps(oneline)
%define module_name Catmandu-VIAF
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Retrieve items from the VIAF authority file
Group: Development/Perl
License: gpl
URL: https://github.com/thedatahub/Catmandu-VIAF

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NETSENSEI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
# From the command line
    $ catmandu export VIAF --id 102333412 to YAML
    ---
    dcterms:identifier: '102333412'
    guid: http://viaf.org/viaf/102333412
    schema:birthDate: 1775-12-16
    schema:deathDate: 1817-07-18
    schema:description: English novelist
    skos:prefLabel: Jane Austen
    ...

    # From a Catmandu Fix
    lookup_in_store(authortName, VIAF, lang:'nl-NL', fallback_lang:'en-US')

    # Perform a direct match between a name and a mainHeadingEl from VIAF
    viaf_match(authorName, -lang:'nl-NL', -fallback_lang:'en-US')

    # Perform a search for a name in VIAF
    viaf_search(authorName, -lang:'nl-NL', -fallback_lang:'en-US')

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/C*

%changelog
