%define module_name Catmandu-Validator-JSONSchema
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catmandu.pm) perl(JSON/Validator.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Throwable/Error.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.15
Release: alt1
Summary: Catmandu Validator for JSON Schema
Group: Development/Perl
License: perl
URL: https://github.com/LibreCat/Catmandu-Validator-JSONSchema

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NJ/NJFRANCK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Catmandu::Validator::JSONSchema;
    use Data::Dumper;

    my $validator = Catmandu::Validator::JSONSchema->new(
        schema => {
            "properties"=> {
                "_id"=> {
                    "type"=> "string",
                    required => 1
                },
                "title"=> {
                    "type"=> "string",
                    required => 1
                },
                "author"=> {
                    "type"=> "array",
                    "items" => {
                        "type" => "string"
                    },
                    minItems => 1,
                    uniqueItems => 1
                }
            },
        }
    );

    my $object = {
        _id => "rug01:001963301",
        title => "In gesprek met Etienne Vermeersch : een zoektocht naar waarheid",
        author => [
            "Etienne Vermeersch",
            "Dirk Verhofstadt"
        ]
    };

    unless($validator->validate($object)){
        print Dumper($validator->last_errors());
    }
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/C*

%changelog
