%define module_name Catmandu-XSD
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catmandu.pm) perl(Catmandu/Template.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Parser/MGC.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Simple.pm) perl(Throwable/Error.pm) perl(XML/Compile.pm) perl(XML/Compile/Cache.pm) perl(XML/LibXML.pm) perl(XML/XPath.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Modules for handling XML data with XSD compilation
Group: Development/Perl
License: perl
URL: https://github.com/LibreCat/Catmandu-XSD

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HO/HOCHSTEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Catmandu::XSD manpage contains modules for handling XML data within the the Catmandu manpage
framework. Parsing and serializing is based on the XML::Compile manpage.

There are two modules available for handling XML data in the Catmandu framework:
the Catmandu::XML manpage and the Catmandu::XSD manpage. The former one can be used when no XML schema
is available for the data. It provides a simple interface to read in XML data and
transform it to other formats. Because the Catmandu::XML manpage doesn't depend on an
XSD schema, it can't know which fields in the input XML files are sequences or
single value elements. Each record is parsed on its own. A record with content:

    <foo>
      <bar>test</bar>
    </foo>

will be parsed into a YAML output like:

    catmandu XML to YAML < test.xml
    --
    bar: test

A record with content:

    <foo>
      <bar>test</bar>
      <bar>test</bar>
    </foo>

will be parsed into a YAL output like:

    catmandu XML to YAML < test2.xml
    --
    bar:
      - test
      - test

In the first case 'bar' will contain a string, in the second case an array. This
might no be what you want in some programming projects. E.g. when you need the 'bar'
field to be always an array of values, then you an XSD schema file is required
containing the exact structure of the XML document:

    test.xsd:
    <?xml version="1.0" encoding="UTF-8" ?>
    <xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema">
        <xs:element name="foo">
         <xs:complexType>
          <xs:sequence>
            <xs:element name="bar" type="xs:string" maxOccurs="unbounded"/>
          </xs:sequence>
         </xs:complexType>
        </xs:element>
    </xs:schema>

And now the test.xml and test2.xml can be parsed with help of Catmandu::XSD:

    catmandu XSD --root '{}foo' --schemas test.xsd to YAML < test.xml
    --
    bar:
      - test

    catmandu XSD --root '{}foo' --schemas test.xsd to YAML < test2.xml
    --
    bar:
      - test
      - test


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/C*

%changelog
