# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(JSON/Any.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(YAML.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Chef
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Write Chef recipes in Perl instead of Ruby.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/H/HO/HOLOWAY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Example:
  
  use Chef;
  
  resource file => '/tmp/foo', sub {
    my $r = shift;
    $r->owner('adam');
    $r->action('create');
  };
  
  resource file => '/tmp/' . node->{attributes}->{hostname} . "_created_with_perl", sub {
    my $r = shift;
    $r->action('create');
  };
  
Would create a file called /tmp/foo, and one called /tmp/HOSTNAME_created_with_perl. (Where HOSTNAME is, well, your hostname).

To use this module, you will need to install Chef, place the included cookbook in your cookbook repository, and place your perl based recipes in files/default/perl_recipes.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
