# BEGIN SourceDeps(oneline):
BuildRequires: perl(Chemistry/File.pm) perl(Chemistry/InternalCoords.pm) perl(Chemistry/InternalCoords/Builder.pm) perl(Chemistry/Mol.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.15
%define module_name Chemistry-File-Mopac
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.15
Release: alt1
Summary: MOPAC 6 input file reader/writer
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IT/ITUB/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module reads and writes MOPAC 6 input files. It can handle both internal
coordinates and cartesian coordinates. It also extracts molecules from summary
files, defined as those files that match /SUMMARY OF/ in the third line.
Perhaps a future version will extract additional information such as the energy
and dipole from the summary file.

This module registers the `mop' format with Chemistry::Mol. For detection
purposes, it assumes that filenames ending in .mop or .zt have the Mopac 
format, as well as files whose first line matches /am1|pm3|mndo|mdg|pdg/i 
(this may change in the future).

When the module reads an input file into $mol, it puts the keywords (usually
the first line of the file) in $mol->attr("mopac/keywords"), the comments
(usually everything else on the first three lines) in
$mol->attr("mopac/comments") and $mol->name, and the internal coordinates for
each atom in $atom->internal_coords. 

When writing, the kind of coordinates used depend on the `coords' option, as
shown in the SYNOPSIS. Internal coordinates are used by default. If the
molecule has no internal coordinates defined or the rebuild option is set,
the build_zmat function from Chemistry::InternalCoords::Builder is used to
renumber the atoms and build the Z-matrix from scratch.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
