# BEGIN SourceDeps(oneline):
BuildRequires: perl(Chemistry/Domain.pm) perl(Chemistry/File.pm) perl(Chemistry/MacroMol.pm) perl(Chemistry/Mol.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.23
%define module_name Chemistry-File-PDB
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.23
Release: alt1
Summary: Protein Data Bank file format reader/writer
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IT/ITUB/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module reads and writes PDB files. The PDB file format is commonly used to
describe proteins, particularly those stored in the Protein Data Bank
(http://www.rcsb.org/pdb/). The current version of this module only reads the
following record types, ignoring everything else:

    ATOM
    HETATM
    ENDMDL 
    END

This module automatically registers the 'pdb' format with Chemistry::Mol,
so that PDB files may be identified and read by Chemistry::Mol->read(). For 
autodetection purpuses, it assumes that files ending in .pdb or having 
a line matching /^(ATOM  |HETATM)/ are PDB files.

The PDB reader and writer is designed for dealing with Chemistry::MacroMol
objects, but it can also create and use Chemistry::Mol objects by throwing some
information away.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
