# BEGIN SourceDeps(oneline):
BuildRequires: perl(DynaLoader.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 0.1
%define module_name Chemistry-MolecularMass
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1
Release: alt7
Summary: Perl extension for calculating
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MK/MKHRAPOV/%module_name-%module_version.tar.gz

%description
Chemistry::MolecularMass is an Object Oriented Perl module for calculating
   molcular mass of chemical compounds implemented with Perl and C.
   Molecular masses of elements stored in the module follow recommendations
   of IUPAC (1995). The module includes elements from H(1) through
   Uuu(113) and isotopes of hydrogen: deuterium and tritium. The module
   also allows a programmer to change the default masses of elements
   for work with isotopes. It also includes some of the more common
   chemical abbreviations as macros and allows to add new macros and
   change the values of old macros. A hash of all macros and a hash
   of all elements can be returned.

   Arbitrary element names can be added, they are expected, however, to
   start with an upper case letter followed by zero or more lower case
   letters. Macros can be any string of characters. Macros are substituted
   only once, so a macro should not evaluate to another macro. Legal
   characters in a formula are: A-Za-z0-9<>{}[]()
   Spaces are not allowed. Parentheses can be nested arbitrarily deep.

   Each MolecularMass object has its own hashes of macros and element 
   masses, so modifications made to one MolecularMass object do NOT
   affect another. The whole thing was programmed with reentrancy
   in mind, so it should be thread safe as well.


%prep
%setup -n Chemistry
# depth is > 1 .. moving up
pushd "MolecularMass"
  mv -f * ../
  mv -f .* ../ ||:
popd

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/C*
%perl_vendor_autolib/*

%changelog
