%define module_name Chemistry-OpenSMILES
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Algorithm/Combinatorics.pm) perl(Chemistry/Elements.pm) perl(Data/Dumper.pm) perl(Graph.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Module/Build/Parse/Yapp.pm) perl(Parse/Yapp.pm) perl(Set/Object.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12.0
Release: alt1
Summary: OpenSMILES format reader
Group: Development/Perl
License: bsd
URL: https://search.cpan.org/dist/Chemistry-OpenSMILES

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ME/MERKYS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Chemistry::OpenSMILES provides support for SMILES chemical identifiers
conforming to OpenSMILES v1.0 specification
(<http://opensmiles.org/opensmiles.html>).

Chemistry::OpenSMILES::Parser reads in SMILES strings and returns them
parsed to arrays of Graph::Undirected objects. Each
atom is represented by a hash. The parser does not have any chemical
inference heuristics, thus it plainly returns properties which it gets
from the SMILES descriptor. That means numbers of implicit hydrogens and
standard aromaticity representation are left for the user to derive.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/C*

%changelog
