%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Chemistry/Pattern.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Chemistry-Reaction
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Explicit chemical reactions
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IT/ITUB/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This package, along with Chemistry::Pattern, provides an
implementation of explicit chemical reactions.

An explicit chemical reaction is a representation of the
transformation that takes place in a given chemical reaction. In an
explicit chemical reaction, a substrate molecule is transformed into a
product molecule by breaking existing bonds and creating new bonds
between atoms.

The representation of an explicit chemical reaction is a molecule in
which the order of a bond before the chemical reaction is
distinguished from the order of the bond after the chemical
reaction. Thus, the breaking of an existing bond is represented by one
of the following before/after pairs:

  3/2, 2/1, 1/0 (breaking of a single bond or reduce order by one)
       3/1, 2/0 (breaking of a double bond or reduce order by two)
            3/0 (breaking of a triple bond)

The creation of a new bond is represented by one of the following
before/after pairs:

  0/1, 1/2, 2/3 (creation of a single bond or increase order by one)
       0/2, 1/3 (creation of a double bond or increase order by two)
            0/3 (creation of a triple bond)

An explicit chemical reaction $react can be forward or reverse applied
once to a molecule $mol at the first subgraph of $mol found which is
isomorphic to the substrate or product of $react:

    my $subst = $react->substrate;
    if ($subst->match($mol)) {
      $react->forward($mol, $subst->atom_map);
    }

Also, an explicit chemical reaction $react can be forward or reverse
applied once to a molecule $mol at each subgraph of $mol which is
isomorphic to the substrate or product of $react:

    my $subst = $react->substrate;
    my @products;
    while ($subst->match($mol)) {
      my $new_mol = $mol->clone; # start from a fresh molecule
      my @map = $subst->atom_map;
      # translate atom map to the clone
      my @m = map { $new_mol->by_id($_->id) } @map;
      $react->forward($new_mol, @m);
      push @products, $new_mol;
    }

Furthermore, an explicit chemical reaction $react can be forward or
reverse applied as long as possible to a molecule $mol at the first
subgraph of $mol found which is isomorphic to the substrate or product
of $react:

    my $subst = $react->substrate;
    while ($subst->match($mol)) {
      $react->forward($mol, $subst->atom_map);
    }


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
