# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.0a
%define module_name Chess-Elo
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0a
Release: alt1
Summary: Perl module to calculate Chess "Elo" ratings
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TB/TBONE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module provides a single function, `elo' which allows one
to calculate individual ratings based on performance. Typically, a
player
is given an initial provisional rating of 1600 points. 
In all cases, one gains and loses
points as a function of the playing strength of both parties and the result
of their encounter.

The formula used is:

    A2 = A1 + 32 (  G - ( 1 / ( 1 + 10 ** ( ( B1 -A1) / 400 ) ) ) )

=over 

=item A2 is Alice's post-game rating

=item A1 is Alice rating before the game against Bob

=item B1 is Bobs rating before the game against Alice

=item G is the game result, in this case:

              1, if A beats B

              0, if A loses to B

              0.5, if A draws to B

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
