%define module_version 0.20
%define module_name Chess-PGN-Parse
# BEGIN SourceDeps(oneline):
BuildRequires: perl(English.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.20
Release: alt1
Summary: reads and parses PGN (Portable Game Notation) Chess files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GM/GMAX/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Chess::PGN::Parse offers a range of methods to read and manipulate Portable Game Notation files.
PGN files contain chess games produced by chess programs following a standard format (http://www.schachprobleme.de/chessml/faq/pgn/). It is among the preferred means of chess games distribution. Being a public, well established standard, PGN is understood by many chess archive programs.
Parsing simple PGN files is not difficult. However, dealing with some of the intricacies of the Standard is less than trivial. This module offers a clean handle toward reading and parsing complex PGN files.

A PGN file has several tags, which are key/values pairs at the header of each game, in the format 
    [key "value"]

After the header, the game follows. A string of numbered chess moves, optionally interrupted by braced comments and recursive parenthesized variants and comments. While dealing with simple braced comments is straightforward, parsing nested comments can give you more than a headache.

Chess::PGN::Parse most immediate methods are:
    read_game() reads one game, separating the tags and the game text.

    parse_game() parse the current game, and stores the moves into an 
        array and optionally saves the comments into an array of hashes
        for furter usage. It can deal with nested comments and recursive
        variations.

    quick_parse_game() Same as the above, but doesn't save the comments, 
        which are just stripped    from the text. It can't deal with nested
        comments. Should be the preferred method when we know that we are
        dealing with simple PGNs.

    smart_parse_game() Best of the above methods. A  preliminary check
        will call parse_game() or quick_parse_game(), depending on the
        presence of nested comments in the game.

    read_all(), quick_read_all(), smart_read_all() will read all the records
        in the current PGN file and return an array of hashes with all the
        parsed details from the games.


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/C*

%changelog
