%define module_name Chouette
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(AnyEvent/HTTP.pm) perl(AnyEvent/Task.pm) perl(Callback/Frame.pm) perl(EV.pm) perl(ExtUtils/MakeMaker.pm) perl(Feersum.pm) perl(File/Temp.pm) perl(JSON/XS.pm) perl(Log/Defer.pm) perl(Log/Defer/Viz.pm) perl(Log/File/Rolling.pm) perl(Plack.pm) perl(Plack/Request/WithEncoding.pm) perl(Regexp/Assemble.pm) perl(Session/Token.pm) perl(YAML.pm) perl(common/sense.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.102
Release: alt1
Summary: REST API Framework
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FR/FRACTAL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Chouette manpage is a framework for making asynchronous HTTP services. It makes some opinionated design choices, but is otherwise fairly flexible.

the AnyEvent manpage is used as the glue to connect all the asynchronous libraries, although Chouette depends on the Feersum manpage and therefore the EV manpage for its event loop. It uses the Feersum manpage in PSGI mode so it can use the Plack manpage for request parsing, and has support for the Plack::Middleware manpage wrappers. the Feersum manpage is the least conservative choice in the stack but there aren't very many alternatives (the Twiggy manpage is a possibility but it is somewhat buggy and you need a hack to use unix sockets).

Chouette generally assumes that its input will be `application/x-www-form-urlencoded'. the Plack::Request::WithEncoding manpage is used so that text is properly decoded (we recommend UTF-8 of course). For output, the default is `application/json' encoded with the JSON::XS manpage. Both the input and output types can be modified, although this is only partially documented so far.

Chouette apps can optionally load a config file and its format is `YAML', loaded with the the YAML manpage module. the Regexp::Assemble manpage is used for efficient route-dispatch.

The above aside, Chouette's main purpose is to glue together several of my own modules into a cohesive whole. These modules have been designed to work together and I have used them to build numerous services, some of which handle a considerable amount of traffic and/or have very complicated requirements.

Chouette was extracted from some of these services I have built before, and I have put in the extra effort required so that all the modules work together in the ways they were designed:

=over

=item the AnyEvent::Task manpage

Allows us to perform blocking operations without holding up other requests.

=item the Callback::Frame manpage

Makes exception handling simple and convenient. You can `die' anywhere and it will only affect the request being currently handl...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
