%define module_name Class-Accessor-Lazy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Accessor.pm) perl(Class/Accessor/Fast.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/Harness.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.003
Release: alt2
Summary: class accessors generation with lazy accessors and fast mode support.
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HU/HURRICUP/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module merges the power of two separate modules: the Class::Accessor manpage and 
the Class::Accessor::Fast manpage. Additionaly providing methods to create lazy 
properties.

It can provide accessors creation methods for your class using two algorithms, 
provided by modules above. But now you may change algorithm in 
the code:

    package Foo;
    use base qw(Class::Accessor::Lazy);

    Foo->follow_best_practice;

    Foo->mk_accessors(slow_accessor);

    Foo->fast_accessors;

    Foo->mk_accessors(fast_accessor);

    # or even
    
    Foo->follow_best_practice
        ->mk_accessors(slow_accessor)
        ->fast_accessors
        ->mk_accessors(fast_accessor);
  
Main documentation may be found on the Class::Accessor manpage and 
the Class::Accessor::Fast manpage pages.

The main extension of this module is possibility to make lazy properties, which
will be inited on first get operation (if there was no write before).

Such methods are useful for database representation classes, where related
data may not be read at all and there is no need to fetch it from database.

For example, there are `Shop' class and `Employee' class. Each `Shop' has 
property `employees', which contains a reference to `Employee' objects list. 
But, you could fetch Shop object from database just to check `income' property
and no don't need information about employees at all. In this case, reading 
employees list and creating list of `Employee' objects makes absolutely no
sense.

But, if you want to get access to them, they should be read from database. And
here are lazy properties comes:

    package Shop;
    use base 'Class::Accessor::Lazy';
    
    Shop->follow_best_practice              # use set/get for accessors/mutators
        ->fast_accessors                    # use Class::Acessor::Fast algorithm
        ->mk_accessors('income')            # regular property
        ->mk_lazy_accessors('employees');   # lazy property
        
    ...
        
    sub _lazy_init_employees
    {
        # here we are reading employees from database and saving them in 
        # property directly or using mutator set_employees
    }

On first `get_employees' invocation, method `Shop::_lazy_init_employees' 
will be invoked automatically, to allow your class to read related data from 
database, for example, and store it in property. 

IMPORTANT: every lazy property of the class MUST have related init method. The
name of such method is `_lazy_init_{property name}'.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
