# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Class-Accessor-PackedString-Set
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Like Class::Accessor::PackedString, but store attributes as they are set
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Class-Accessor-PackedString-Set

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is a builder for classes that use string as memory storage backend.
The string is initially empty when there are no attributes set. When an
attribute is set, string will be appended with this data:

 | size        | description                        |
 +-------------+------------------------------------+
 | 1 byte      | index of attribute                 |
 | (pack size) | attribute value, encoded by pack() |

When another attribute is set, string will be further appended. When an
attribute is unset (undef'd), its entry will be removed in the string.

This module is similar to the Class::Accessor::PackedString manpage. Using string (of
pack()-ed data) is useful in situations where you need to create many (e.g.
thousands+) objects in memory and want to reduce memory usage, because
string-based objects are more space-efficient than the commonly used hash-based
objects. Unlike in Class::Accessor::PackedString, space is further saved by only
storing set attributes and not unset attributes. This particularly saves
significant space if you happen to have many attributes with usually only a few
of them set.

The downsides are: 1) you have to predeclare all the attributes of your class
along with their types (pack() templates); 2) you can only store data which can
be pack()-ed; 3) slower speed, because unpack()-ing and re-pack()-ing are done
everytime an attribute is accessed or set.

Caveats:

There is a maximum of 256 attributes.

=for Pod::Coverage .+
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/C*

%changelog
