# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Config/Abstraction.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(JSON/MaybeXS.pm) perl(LWP/Protocol/https.pm) perl(Log/Abstraction.pm) perl(Test/DescribeMe.pm) perl(Test/Most.pm) perl(Test/Needs.pm) perl(YAML/XS.pm)
# END SourceDeps(oneline)
%define module_name Class-Debug
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Add Runtime Debugging to a Class
Group: Development/Perl
License: open_source
URL: https://metacpan.org/pod/Class::Debug

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NH/NHORNE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The `Class::Debug' module is a lightweight utility designed to inject runtime debugging capabilities into other classes,
primarily by layering configuration and logging support.

the Log::Abstraction manpage and the Config::Abstraction manpage are modules developed to solve a specific need:
runtime configurability without needing to rewrite or hardcode behaviours.
The goal is to allow individual modules to enable or disable features on the fly, and to do it using whatever configuration system the user prefers.

Although the initial aim was general configurability,
the primary use case that.e's emerged has been fine-grained logging control,
more flexible and easier to manage than what you'd typically do with the Log::Log4perl manpage.
For example,
you might want one module to log verbosely while another stays quiet,
and be able to toggle that dynamically - without making invasive changes to each module.

To tie it all together,
there is `Class::Debug'.
It sits on the Log::Abstraction manpage and the Config::Abstraction manpage,
and with just a couple of extra lines in a class constructor,
you can hook in this behaviour seamlessly.
The intent is to keep things modular and reusable,
especially across larger systems or in situations where you want user-selectable behaviour.

Add this to your constructor:

   package My::Module;

   use Class::Debug;
   use Params::Get;

   sub new {
        my $class = shift;
        my $params = Params::Get(undef, \@_);

        $params = Class::Debug::setup($class, $params);

        return bless $params, $class;
    }

Throughout your class, add code such as:

    sub method
    {
        my $self = shift;

        $self->{'logger'}->trace(ref($self), ': ', __LINE__, ' entering method');
    }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/C*

%changelog
