%define module_name Class-Easy
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(ExtUtils/MakeMaker.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.18
Release: alt8
Summary: make class routine easy
Group: Development/Perl
License: perl
URL: http://perlhug.com

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AP/APLA/%{module_name}-%{version}.tar.gz

%description
SYNOPSIS

_# automatic loading of strict, warnings and utf8, like common::sense
_use Class::Easy::Import;
_# or same as above + functions like 'has', 'try_to_use', 'timer' and 'logger'
_use Class::Easy;
_
_# try to load package IO::Easy, return 1 when success
_try_to_use ('IO::Easy');
_
_# try to load package IO::Easy, but search for package existence
_# within %%%%INC instead of symbolic table
_try_to_use_inc ('IO::Easy');
_
_# for current package
_has "property_ro"; # make readonly object accessor
_has "property_rw", is => 'rw'; # make readwrite object accessor
_
_has global25 => 25; # make readonly static accessor with value 25
_has "global", global => 1, is => 'rw'; # make readwrite static accessor

_# make subroutine in package main
_make_accessor ('main', 'initialize', default => sub {
__$::initialized = 1;
__return "initialized!";
_});
_
_# see documentation for Class::Easy::Log
_
_# string "[PID] [PACKAGE(STRING)] [DBG] something" logged
_debug "something";

_# see documentation for Class::Easy::Timer

_my $t = timer ('long operation');
_# .eI long operation

_my $time = $t->lap ('another long op');
_# .eI

_$time = $t->end;
_# $time contains time between last 'lap' or 'timer'
_# and 'end' call

_$time = $t->total;
_# now $time contains total time between timer init
_# and end call

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/C*
%perl_vendor_autolib/*

%changelog
