# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Class-Multimethods
%define upstream_version 1.701

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_4

Summary:    A multiple dispatch mechanism for Perl
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Class/%{upstream_name}-%{upstream_version}.tar.gz


BuildArch: noarch
Source44: import.info


%description
The Class:Multimethod module exports a subroutine (&multimethod) that can
be used to declare other subroutines that are dispatched using a algorithm
different from the normal Perl subroutine or method dispatch mechanism.

Normal Perl subroutines are dispatched by finding the appropriately-named
subroutine in the current (or specified) package and calling that. Normal
Perl methods are dispatched by attempting to find the appropriately-named
subroutine in the package into which the invoking object is blessed or,
failing that, recursively searching for it in the packages listed in the
appropriate '@ISA' arrays.

Class::Multimethods multimethods are dispatched quite differently. The
dispatch mechanism looks at the classes or types of each argument to the
multimethod (by calling 'ref' on each) and determines the "closest"
matching _variant_ of the multimethod, according to the argument types
specified in the variants' definitions (see the Finding the "nearest"
multimethod manpage for a definition of "closest").

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
