# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(YAML.pm) perl(overload.pm) perl(threads/shared.pm)
# END SourceDeps(oneline)
%define module_version 1.10
%define module_name Class-PseudoHash
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.10
Release: alt1
Summary: Emulates Pseudo-Hash behaviour via overload
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AU/AUDREYT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Due to its impact on overall performance of ordinary hashes, pseudo-hashes
are deprecated in Perl 5.8.

As of Perl 5.10, pseudo-hashes have been removed from Perl, replaced by
restricted hashes provided by the Hash::Util manpage.  Additionally, Perl 5.10 no
longer supports the `fields::phash()' API.

Although the Pseudo-hashes: Using an array as a hash entry in the perlref manpage recommends
against depending on the underlying implementation (i.e. using the first
array element as hash indice), there are undoubtly many legacy codebase
still depending on pseudohashes; elimination of pseudo-hashes would
therefore require a massive rewrite of their programs.

Back in 2002, as one of the primary victims, I tried to devise a drop-in
solution that could emulate exactly the same semantic of pseudo-hashes, thus
keeping all my legacy code intact.  So `Class::PseudoHash' was born.

Hence, if your code use the preferred `fields::phash()' function, just write:

    use fields;
    use Class::PseudoHash;

then everything will work like before.  If you are creating pseudo-hashes 
by hand (`[{}]' anyone?), just write this instead:

    $ref = Class::PseudoHash->new;

and use the returned object in whatever way you like.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
