%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.2
%define module_name Class-Random
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2
Release: alt1
Summary: Random behaviour for instances
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PM/PMH/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module allows you to create classes which randomly change
their behaviour or implementation according to a specified behaviour.
This is done simply by using the module, passing a parameter list
which dictates the required behaviour.  A number of behaviours are
possible, determined by the first argument in the `use Class::Random'
line:

=over 4

=item subclass

The `subclass' behaviour is given a list of class names, and installs a
`new' class method in the calling package. This method picks one of the
class names given, and calls that class' `new' method. Note that if
a `new' method is defined after this `use' statement, it will
override the one defined by `Class::Random'.

This behaviour implements Damian Conway's idea of choosing a random
implementation for each object created, in order to discourage
users from directly accessing the object's internals, rather than
using the interface like they are supposed to do.

=item shuffle

The `shuffle' behaviour is given a list of class names, which are used to
populate the calling package's `@ISA' array. It also installs an object
in the first element of `@ISA', which shuffles the rest of the array
when accessed. This has the effect of causing each method called on the
object to change the inheritance hierarchy.

=item choose

The `choose' behaviour is like the `shuffle' behaviour, except that each
element of the list is a complete `@ISA' array. This allows one of a
number of different lists of base classes to be chosen with each method
call.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/C*

%changelog
