%define module_name Class-StateMachine-Declarative
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/StateMachine.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(mro.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt2
Summary: Define state machines classes in a high level declarative fashion
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SA/SALVA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Class::StateMachine::Declarative is a the Class::StateMachine manpage (from now
on C::SM) extension that allows to define most of a state machine
class declaratively.

The way to create a new Class::StateMachine derived class from this
module is to pass a set of state declarations through its use
statement:

  use Class::StateMachine::Declarative
      $state1 => $decl1,
      $state2 => $decl2,
      ...;

Note that Class::StateMachine::Declarative will not set `@ISA' for
you, as you may want to derive your classes not from C::SM directly
but from some of its subclasses. For instance:

  use parent 'My::StateMachine::BaseClass';
  use Class::StateMachine::Declarative @decl;

The following attributes can be used to define the state behaviour:

=over 4

=item enter => $method

method to be called when the object enters in the state

=item leave => $method

method to be called when the object leaves the state

=item advance => $event

when this event (method call) happens the state is changed to the next one declared.

=item before => \%%before

where %%before contains pairs `$event => $action'

When any of the events on the declaration happens, the corresponding
action (a method actually) will be called before the final `advance',
`on', `transition' or `ignore' action is carried out.

Also, `before' actions are stacked on the hierarchy. So, if you
define a before action for a state and then another for some substate,
then both `before' actions will be called when on the substate.

For instance:

  Class::StateMachine::Declarative
    foo => { ignore => ['bar'],
             before => { bar => 'bar_from_foo' },
             substates => [ doz => { before => { bar => 'bar_from_doz' } } ] };

Invoking `bar' from the state `foo/doz' calls both `bar_from_foo'
and `bar_from_doz' methods.

Note that `before' actions are not carried out when the principal
action is marked as delayed (via the `delay' declaration).

Before actions is the ideal place to propagate events to other
objects.

=item on => \%%on

where %%on co...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
