# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(CPAN.pm) perl(Date/Manip.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Handle.pm) perl(Pod/Parser.pm) perl(Scriptalicious.pm) perl(Set/Object.pm) perl(Template.pm) perl(Test/More.pm) perl(Test/Simple.pm) perl(YAML.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 1.57
%define module_name Class-Tangram
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.57
Release: alt1
Summary: Tangram-friendly classes, DWIM attributes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SA/SAMV/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Class::Tangram is a tool for defining objects attributes.  Simply
define your object's fields/attributes using the same data structure
introduced in _A Guided Tour of Tangram_ (see the SEE ALSO entry elsewhere in this document) and
detailed in the Tangram::Schema manpage, and you get objects that work As You'd
Expect(tm).

Class::Tangram has no dependancy upon Tangram, and vice versa.
Neither requires anything special of your objects, nor do they insert
any special fields into your objects.  This is a very important
feature with innumerable benefits, and few (if any) other object
persistence tools have this feature.

So, fluff aside, let's run through how you use Class::Tangram to make
objects.

First, you decide upon the attributes your object is going to have.
You might do this using UML, or you might pick an existing database
table and declare each column to be an attribute (you can leave out
"id"; that one is implicit; also, leave out foreign keys until later).

Your object should use Class::Tangram as a base class;

  use base qw(Class::Tangram)

or for older versions of perl:

  use Class::Tangram;
  use vars qw(@ISA);
  @ISA = qw(Class::Tangram)

You should then define a `$fields' variable in the scope of the
package, that is a hash from attribute types (see
the Tangram::Type manpage) to either an array of attribute names, or
another hash from attribute names to options hashes (or
`undef').  The layout of this structure coincides exactly with the
`fields' portion of a tangram schema (see the Tangram::Schema manpage), though
there are some extra options available.

This will hereon in be referred to as the `object schema' or just
`schema'.

For example,

 package Orange;
 use base qw(Class::Tangram);

 our $fields = {
     int => {
         juiciness => undef,
         segments => {
             # this code reference is called when this
             # attribute is set, to check the value is
             # OK - note, no object is passed, this is for
             # simple marshalling only.
             check_func => sub {
                 die "too many segments"
                     if (${(shift)} > 30);
             },
             # the default for this attribute.
             init_default => 7,
         },
     },
     ref => {
        grower => {
        },
     },

     # 'required' attributes - insist that these fields are
     # set, both with constructor and set()/set_X methods
     string => {
         # true: 'type' must have non-empty value (for
         # strings) or be logically true (for other types)
_ type => { required => 1 },

_ # false: 'tag' must be defined but may be empty
_ tag => { required => '' },
     },

     # fields allowed by Class::Tangram but not ever
     # stored by Tangram - no type checking by default
     transient => [ qw(_tangible) ],
 };

It is of critical importance to your sanity that you understand how
anonymous hashes and anonymous arrays work in Perl.  Some additional
features are used above that have not yet been introduced, but you
should be able to look at the above data structure and see that it
satisfies the conditions stated in the paragraph before it.  If it is
hazy, I recommend reading the perlref manpage or the perlreftut manpage.

When the schema for the object is first imported (see the Schema import entry elsewhere in this document), Class::Tangram defines accessor functions for each of the
attributes defined in the schema.  These accessor functions are then
available as `$object->function' on created objects.  By virtue
of inheritance, various other methods are available.

From Class::Tangram 1.12 onwards, perl's `AUTOLOAD' feature is not
used to implement accessors; closures are compiled when the class is
first used.

%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
