%define module_name Class-Tiny-ConstrainedAccessor
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Tiny.pm) perl(Config.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Getopt/Long.pm) perl(Import/Into.pm) perl(Module/Metadata.pm) perl(MooX/Types/MooseLike.pm) perl(MooX/Types/MooseLike/Base.pm) perl(MooseX/Types.pm) perl(MooseX/Types/Moose.pm) perl(Mouse.pm) perl(MouseX/Types.pm) perl(MouseX/Types/Mouse.pm) perl(Path/Class.pm) perl(Pod/Markdown.pm) perl(Scalar/Util.pm) perl(Specio.pm) perl(Specio/Declare.pm) perl(Specio/Exporter.pm) perl(Specio/Library/Builtins.pm) perl(Test/Builder.pm) perl(Test/Exception.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Type/Nano.pm) perl(Type/Tiny.pm) perl(lib/relative.pm) perl(parent.pm) perl(strict.pm) perl(vars/i.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.000015
Release: alt1
Summary: Generate Class::Tiny accessors that apply type constraints
Group: Development/Perl
License: apache
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CX/CXW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Class::Tiny manpage uses custom accessors if they are defined before the
`use Class::Tiny' statement in a package.  This module creates custom
accessors that behave as standard `Class::Tiny' accessors except that
they apply type constraints (`isa' relationships).  Type constraints
can come from the Type::Tiny manpage, the MooseX::Types manpage, the MooX::Types::MooseLike manpage,
the MouseX::Types manpage, or the Specio manpage.

Example of a class using this package:

    package SampleClass;
    use Scalar::Util qw(looks_like_number);

    use Type::Tiny;

    my $MediumInteger;
    BEGIN {
        # Create the type constraint
        $MediumInteger = Type::Tiny->new(
            name => 'MediumInteger',
            constraint => sub { looks_like_number($_) and $_ >= 10 and $_ < 20 }
        );
    }

    use Class::Tiny::ConstrainedAccessor {
        medint => $MediumInteger,           # create accessor sub medint()
        med_with_default => $MediumInteger,
    };

    # After using ConstrainedAccessor, actually define the class attributes.
    use Class::Tiny qw(medint regular), {
        med_with_default => 12,
    };

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE README
%perl_vendor_privlib/C*

%changelog
