# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Class-TransparentFactory
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Transparently choose a provider class with an automatic facade
Group: Development/Perl
License: MIT
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GA/GAAL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is intended for developers who find they need to refactor
code away from one provider of functionality to a factory + set of
API-compatible providers. It's not that factories are very difficult to
write or maintain, but code that uses them tends to be somewhat cluttered.

With Class-TransparentFactory, your user code remains exactly as it was
before you split off to several providers; the original module class
turns into a facade in which class methods are automatically turned into
proxies for the appropriate provider class.

To use Class-TransparentFactory in user code, no change is needed. (That
is the point!)  To use it in your libraries, you need to follow these
steps:

=over 4

=item Move all your actual implementation into another module.

Its name is not important to Class::TransparentFactory, but let's call
it `ProviderOne' here. The old namespace by which the implementation
was known we will call `Facade'.

=item Declare `Facade' as a transparent factory.

See *import* below for details. For a typical OOPish module with no
special class methods, this will suffice:

  package Facade;
  use Class::TransparentFactory qw(new);

=item Implement your factory.

See *impl* for details. Here is where you put the business logic
that determines which provider is suitable and should be used for this
particular call.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
