%define module_name Class-XSConstructor
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Exporter/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Ref/Util.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/Requires.pm) perl(Type/Nano.pm) perl(Types/Standard.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.009
Release: alt4
Summary: a super-fast (but limited) constructor in XS
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Class-XSConstructor

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz

%description
the Class::XSAccessor manpage is able to provide you with a constructor for your class,
but it's fairly limited. It basically just does:

  sub new {
    my $class = shift;
    bless { @_ }, ref($class)||$class;
  }

Class::XSConstructor goes a little further towards Moose-like constructors,
adding the following features:

=over

=item *

Supports initialization from a hashref as well as a list of key-value pairs.

=item *

Only initializes the attributes you specified. Given the example in the
synposis:

  my $obj = Person->new(name => "Alice", height => "170 cm");

The height will be ignored because it's not a defined attribute for the
class.

=item *

Supports required attributes using an exclamation mark. The name attribute
in the synopsis is required.

=item *

Provides support for type constraints.

  use Types::Standard qw(Str Int);
  use Class::XSConstructor (
    "name!"    => Str,
    "age"      => Int,
    "email"    => Str,
    "phone"    => Str,
  );

Type constraints can also be provided as coderefs returning a boolean:

  use Types::Standard qw(Str Int);
  use Class::XSConstructor (
    "name!"    => Str,
    "age"      => Int,
    "email"    => sub { !ref($_[0]) and $_[0] =~ /\@/ },
    "phone"    => Str,
  );

Type constraints are likely to siginificantly slow down your constructor.

Note that Class::XSConstructor is only building your constructor for you.
For read-write attributes, *checking the type constraint in the accessor
is your responsibility*.

=item *

Supports Moose/Moo/Class::Tiny-style `BUILD' methods.

Including `__no_BUILD__'.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT CREDITS LICENSE Changes README examples
%perl_vendor_archlib/C*
%perl_vendor_autolib/*

%changelog
