# BEGIN SourceDeps(oneline):
BuildRequires: perl(Clone.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm)
# END SourceDeps(oneline)
%define module_version 0.15
%define module_name ClearCase-CRDB
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.15
Release: alt1
Summary: Class for ClearCase config-record analysis
Group: Development/Perl
License: perl
Url: %CPAN %module_name
BuildArch: noarch
Source0: http://cpan.org.ua/authors/id/D/DS/DSB/%module_name-%module_version.tar.gz

%description
A ClearCase::CRDB object represents the (potentially recursive)
*configuration record* (hereafter `*CR*') of a set of *derived
objects* (hereafter `*DOs*').  It provides methods for easy
extraction of parts of the CR such as the build script, MVFS files used
in the creation of a given DO, make macros employed, etc. This is the
same data available from ClearCase in raw textual form via `cleartool
catcr'; it's just broken down for easier access and analysis.

An example of what can be done with ClearCase::CRDB is the provided
*whouses* script which, given a particular DO, can show recursively
which files it depends on or which files depend on it.

Since recursively deriving a CR database can be a slow process for
large build systems and can burden the VOB database, the methods
`ClearCase::CRDB->store' and `ClearCase::CRDB->load' are
provided. These allow the derived CR data to be stored in its processed
form to a persistent storage such as a flat file or database and
re-loaded from there. For example, this data might be derived once per
day as part of a nightly build process and would then be available for
use during the day without causing additional VOB load.

The provided `ClearCase::CRDB->store' and
`ClearCase::CRDB->load' methods save to a flat file in
human-readable text format. Different formats may be used by
subclassing these two methods. An example subclass
`ClearCase::CRDB::Storable' is provided; this uses the Perl module
*Storable* which is a binary format. If you wanted to store to a
relational database this is how you'd do it, using Perl's DBI modules.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version
sed -i -e '1s,^#\!(/opt/rational/clearcase/bin/Perl|/opt/rational/common/bin/ratlperl|/usr/local/bin/perl),#!/usr/bin/perl,' cr2mf macroize metado whouses
sed -i -e 's,/opt/rational/common/bin/ratlperl,/usr/bin/perl,g' whouses
%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
