# BEGIN SourceDeps(oneline):
BuildRequires: perl(Argv.pm) perl(Benchmark.pm) perl(ClearCase/Argv.pm) perl(Clone.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm)
# END SourceDeps(oneline)
%define module_version 0.60
%define module_name ClearCase-SyncTree
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.60
Release: alt1
Summary: Synchronize a tree of files with a tree of elements
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DS/DSB/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module provides an infrastructure for programs which want to
*synchronize* a set of files, typically a subtree, with a similar
destination subtree in VOB space.  The enclosed *synctree* script is
an example of such a program.

The source area may be in a VOB or may be a regular filesystem; the
destination area must be in a VOB. Methods are supplied for adding,
subtracting, and modifying destination files so as to make that area
look identical to the source.

Symbolic links are supported, even on Windows (of course in this case
the source filesystem must support them, which is only likely in the
event of an MVFS->MVFS transfer). Note that the text of the link is
transported verbatim from source area to dest area; thus relative
symlinks may no longer resolve in the destination.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
