%define module_name CodeGen-Protection
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Digest/MD5.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Module/Runtime.pm) perl(Moo.pm) perl(Perl/Tidy.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Type/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Safely rewrite parts of generated code
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/CodeGen::Protection

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OV/OVID/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
If you might find the Tutorial to be useful.

Code that writes code can be a powerful tool, especially when you need to
generate lots of boilerplate. However, when a developer takes the generated
code, they can easily rewrite that code in a way that no longer works, or make
good changes that get wiped out if the code is regenerated.
DBIx::Class::Schema::Loader
protects against this by marking blocks of code with start and end comments
and an MD5 checksum. If you change any of the code between those comments,
regenerating your schema will fail.

This module takes this idea and generalizes it. It allows you to do a safe
partial rewrite of documents. At the present time, we support Perl and HTML.

In short, we wrap your "protected" (`protected_code') code in start and end
comments, with checksums for the code:

    #<<< CodeGen::Protection::Format::Perl 0.01. Do not touch any code between this and the end comment. Checksum: fa97a021bd70bf3b9fa3e52f203f2660
    
    # protected code goes here

    #>>> CodeGen::Protection::Format::Perl 0.01. Do not touch any code between this and the start comment. Checksum: fa97a021bd70bf3b9fa3e52f203f2660

Or:

    <!-- CodeGen::Protection::Format::HTML 0.01. Do not touch any code between this and the end comment. Checksum: c286b9b2577e085df857227eae996c40 -->
    
        <ol>
          <li>This is a list</li>
          <li>This is the second entry.</li>
        </ol>
    
    <!-- CodeGen::Protection::Format::HTML 0.01. Do not touch any code between this and the start comment. Checksum: c286b9b2577e085df857227eae996c40 -->

If calling the `rewrite_code' function, this module removes the code between
the `existing_code''s start and end markers and replaces it with the
`protected_code'. If the code between the start and end markers has been
altered, it will no longer match the checksums and rewriting the code will
fail.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE CONTRIBUTING.md Changes
%perl_vendor_privlib/T*
%perl_vendor_privlib/C*

%changelog
