# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Class/Field.pm) perl(Config.pm) perl(Convert/Base32.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Data/UUID.pm) perl(Digest/MD5.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Path.pm) perl(FileHandle.pm) perl(Filter/Util/Call.pm) perl(IO/All.pm) perl(LWP/Simple.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Text/Diff.pm) perl(XXX.pm) perl(YAML.pm) perl(YAML/Syck.pm) perl(diagnostics.pm) perl(inc/Module/Install.pm) perl(overload.pm) perl(threads/shared.pm)
# END SourceDeps(oneline)
%define module_version 0.10
%define module_name CogBase
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: A CogBase Implementation in Perl
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IN/INGY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
CogBase is a Object Database Management System.

Some interesting characteristics of its design are:

=over

=item * All objects are stored as nodes.

=item * Every node has a universally unique id.

=item * Every node has a type.

=item * Every type has a schema.

=item * Every schema, is itself, a node in the db.

=item * Every schema has a base/super schema that it inherits from.

=item * Schemas can be used to generate programming language (Perl) classes
for every type (schema) of node.

=item * CogBase defines several core scalar types.

=item * CogBase defines one core schema (that every schema inherits from).

=item * Every node has one or more revisions.

=item * Every revision is immutable.

=item * Database access methods are connect, create, store, fetch, query
and disconnect.

=item * All nodes have access control based on the Unix File System.

=item * HTTP is used for the network layer. GET and POST are used for all
operations.

=item * Database can be used over network or embedded.

=item * Access control is based on Unix File System

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
