%define module_name Config-AST
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Clone.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(File/stat.pm) perl(Module/Metadata.pm) perl(Scalar/Util.pm) perl(Text/Locus.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.07
Release: alt1
Summary: abstract syntax tree for configuration files
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SG/SGRAY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module aims to provide a generalized implementation of parse tree
for various configuration files. It does not implement parser for any existing
configuration file format. Instead, it provides an API that can be used by
parsers to build internal representation for the particular configuration file
format.

See Config::Parser module for an implementation of a parser based on
this module.

A configuration file in general is supposed to consist of statements of two
kinds: simple statements and sections. A simple statement declares or sets
a configuration parameter. Examples of simple statements are:

    # Bind configuration file:
    file "cache/named.root";

    # Apache configuration file:
    ServerName example.com

    # Git configuration file:
    logallrefupdates = true

A section statement groups together a number of another statements. These
can be simple statements, as well as another sections. Examples of sections
are (with subordinate statements replaced with ellipsis):

    # Bind configuration file:
    zone "." {
       ...
    };

    # Apache configuration file:
    <VirtualHost *:80>
       ...
    </VirtualHost>

    # Git configuration file:
    [core]
       ...

The syntax of Git configuration file being one of the simplest, we will use
it in the discussion below to illustrate various concepts.

The abstract syntax tree (AST) for a configuration file consists of nodes.
Each node represents a single statement and carries detailed information
about that statement, in particular:

=over 4

=item locus

Location of the statement in the configuration. It is represented by an
object of class Text::Locus.

=item order

0-based number reflecting position of this node in the parent section
node.

=item value

For simple statements - the value of this statement.

=item subtree

For sections - the subtree below this section.

=back

The type of each node can be determined using the following node attributes:

=over 4

=item is_section

True if node is a section node.

=item is_value

True if ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/C*

%changelog
