Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       perl-Config-ApacheFormat
Version:    1.2
Release:    alt2_37
Summary:    Use Apache format config files
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:    GPL-1.0-or-later OR Artistic-1.0-Perl
URL:        https://metacpan.org/release/Config-ApacheFormat
Source0:    https://cpan.metacpan.org/authors/id/S/SA/SAMTREGAR/Config-ApacheFormat-%{version}.tar.gz
# Fix a Use of uninitialized value in lc warning, CPAN RT#132271
Patch0:     Config-ApacheFormat-1.2-Fix-a-Use-of-uninitialized-value-in-lc-warning.patch
BuildArch:  noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Class/MethodMaker.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Text/Balanced.pm)
BuildRequires:  perl(warnings.pm)
# Tests:
BuildRequires:  perl(Test/More.pm)
# (Data::Dumper is used only in runtime, not in tests)
Requires:   perl(Class/MethodMaker.pm) >= 1.080
Requires:   perl(Data/Dumper.pm)
Requires:   perl(File/Spec.pm) >= 0.820
Requires:   perl(Text/Balanced.pm) >= 1.890

# Remove under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(Class.MethodMaker\|File.Spec\|Text.Balanced\).pm)/d

%description
This Perl module is designed to parse a configuration file in the same syntax
used by the Apache web server (see <http://httpd.apache.org/> for details).
This enables you to build applications which can be easily managed by
experienced Apache administrators.  Also, by using this module, you'll benefit
from the support for nested blocks with built-in parameter inheritance. This
can greatly reduce the amount or repeated information in your configuration
files.

%prep
%setup -q -n Config-ApacheFormat-%{version}
%patch0  -p1

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
