# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(Hash/Merge.pm) perl(Module/Build/Tiny.pm) perl(Path/Tiny.pm) perl(Test/Deep.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.0800
%define module_name Config-FromHash
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0800
Release: alt1
Summary: Read config files containing hashes
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Config-FromHash

Source0: http://cpan.org.ua/authors/id/C/CS/CSSON/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Config::FromHash is yet another config file handler. This one reads config files that contain a Perl hash.

The following options are available

    my $config = Config::FromHash->new(
        filename => 'path/to/config.file',
        filenames => ['path/to/highest_priority_config.file', 'path/to/might_be_overwritten.file'],
        environment => 'production',
        environments => ['production', 'standard'],
        data => { default => { data => ['structure'] } },
        require_all_files => 1,
    );

`data'

Optional. If it exists its value is used as the default settings and will be overwritten if the same setting exists in a config file.

`filename' or `filenames'

Optional. `filenames' is an alias for `filename'. It reads better to use `filenames' if you have many config files.

Files are parsed left to right. That is, as soon as a setting is found in a file (while reading left to right) that setting
is not overwritten.

`environment' or `environments'

Optional. `environments' is an alias for `environment' It reads better to use `environment' if you have many environments.

If this is set its value is inserted into all config file names, just before the final dot.

Environments are read left to right. All files from each environment is read before moving on to the next environment. See Examples below.

An environment can be `undef'.

`require_all_files'

Default: `0'

If set to a true value Config::FromHash will `die' if any config file doesn't exist. Otherwise it will silently skip such files.

`sep'

Default: `qr{/}'

The separator used to split the argument to `get()':

    my $config = Config::FromHash->new(sep => qr{\.}, data => { some => { nested => { data => { is => 'deep' }}}});

    # prints 'deep'
    print $config->get('some.nested.data.is');


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/C*

%changelog
