%define module_name Config-JSON-Enhanced
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cwd.pm) perl(Data/Roundtrip.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(JSON.pm) perl(Test/More.pm) perl(Test2/Plugin/UTF8.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: JSON-based config with C/Shell-style comments, verbatim sections and variable substitutions
Group: Development/Perl
License: artistic_2
URL: https://metacpan.org/module/Config::JSON::Enhanced

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLIAKO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides subroutine `config2perl()' for parsing configuration content,
from files or strings,  based on, what I call, "enhanced JSON" (see section
the ENHANCED JSON FORMAT entry elsewhere in this document for more details). Briefly, it is standard JSON which allows:


=over 2

=item * `C'-style, `C++'-style or `shell'-style comments.

=item * template variables (e.g. `<%% appdir %%>') which are substituted with user-specified data.

=item * verbatim sections which are a sort of here-doc for JSON
which may be spanning multiple
lines and contained single and double quotes are not required to be escaped.
This enhances the readbility of long JSON which may contain, in my case,
long shell scripts with lots of quotes and newlines.

=back

It has been tested with unicode data (see `t/25-config2perl-complex-utf8.t')
with success. But who knows ?!?!

Here is an example:

    use Config::JSON::Enhanced qw/config2perl/;

    my $configdata = 'EOJ';
    {
        "a" : "abc",
        "b" : {
          /* this is a comment */
          "c" : <%%begin-verbatim-section%%>
      This is a multiline string
    /* all spaces between the start of the line and
       the first char will be erased.
       Newlines are escaped and kept.
    */
      with "quoted text" and 'this also'
      and comments like /* this */ or
      # this
      will be retained in the string
    /* white space from beginning and end will be erased */

    <%%end-verbatim-section%%>
          ,
          "d" : [1,2,<%% tempvar0 %%>],
          "e" : "< %% tempvar1 %% > user and <%%tempvar2%%>!"
        }
    }
    EOJ

    my $perldata = config2perl({
        'string' => $configdata,
        'commentstyle' => "C,shell,CPP",
        'variable-substitutions' => {
            # substitutions do not add extra quotes
            'tempvar0' => 42,
            'tempvar1' => 'hello',
            'tempvar2' => 'goodbye',
        },
    });
    die "call to config2perl() has failed" unless defined $perldata;

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

    # and here is the dump of the perl data struct...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md Changes
%perl_vendor_privlib/C*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
