Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Config-Properties
Version:        1.80
Release:        alt2_29
Summary:        Read and write property files
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Config-Properties
Source0:        https://cpan.metacpan.org/authors/id/S/SA/SALVA/Config-Properties-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  glibc-core glibc-timezones glibc-utils iconv
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Errno.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(PerlIO.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Text/Wrap.pm)
BuildRequires:  perl(warnings.pm)
# Tests:
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(utf8.pm)
Requires:       perl(Text/Wrap.pm) >= 2001.092.900
Source44: import.info

%description
Config::Properties is a near implementation of the java.util.Properties
API. It is designed to allow easy reading, writing and manipulation of Java-
style property files.

%prep
%setup -q -n Config-Properties-%{version}

# Fix files encoding
for i in Changes README; do {
iconv -f iso8859-1 -t utf-8 $i > $i.utf8 \
&& touch -r $i $i.utf8 \
&& mv -f $i.utf8 $i; };
done;


%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
