%define module_name Config-Structured
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Prototyped.pm) perl(Data/Structure/Deserialize/Auto.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/All.pm) perl(Moose/Util/TypeConstraints.pm) perl(Readonly.pm) perl(Syntax/Keyword/Try.pm) perl(Test/More.pm) perl(Test2/Suite.pm) perl(XS/Parse/Keyword.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.01
Release: alt1
Summary: Provides generalized and structured configuration value access
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TY/TYRRMINAL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Config::Structured manpage provides a structured method of accessing configuration values

  This is predicated on the use of a configuration `structure' (required), This structure
  provides a hierarchical structure of configuration branches and leaves. Each branch becomes
  a the Config::Structured manpage method which returns a new the Config::Structured manpage instance rooted at
  that node, while each leaf becomes a method which returns the configuration value.

  The configuration value is normally provided in the `config' hash. However, a `config' node
  for a non-Hash value can be a hash containing the "source" and "ref" keys. This permits sourcing
  the config value from a file (when source="file") whose filesystem location is given in the "ref"
  value, or an environment variable (when source="env") whose name is given in the "ref" value.

  *Structure Leaf Nodes* are required to include an "isa" key, whose value is a type 
  (see the Moose::Util::TypeConstraints manpage). If typechecking is not required, use isa => 'Any'.
  There are a few other keys that the Config::Structured manpage respects in a leaf node:

  =over

  =item `default'

  This key's value is the default configuration value if a data source or value is not provided by
  the configuation.

  =item `description'

  =item `notes'

  A human-readable description and implementation notes, respectively, of the configuration node. 
  the Config::Structured manpage does not do anything with these values at present, but they provides inline 
  documentation of configuration directivess within the structure (particularly useful in the common 
  case where the structure is read from a file)

  =back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes README.md
%perl_vendor_privlib/C*

%changelog
