%define module_name ConstantCalculus-CircleConstant
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(bignum.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Perl extension for calculating the circle constant in high accurccy.
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/Z/ZT/ZTENRETEP/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The circle constant is a mathematical constant. There are two variants of the
circle constant. Most common is the use of Pi (.e) for the circle constant. More
uncommon is the use of Tau (.') for the circle constant. The relation between 
them is .' = 2 .e. There can be found other denotations for the well known name
Pi. The names are Archimedes's constant or Ludolph's constant. The circle constant
is used in formulas across mathematics and physics.

The circle constant is the ratio of the circumference U of a circle to its
diameter d, which is .e = U/d or .' = 2 U/d. It is an irrational number, which
means that it cannot be expressed exactly as a ratio of two integers. Fractions
such as 22/7 or 355/113 can be used to approximate the circle constant Pi, whereas
44/7 or 710/113 represent the approximation of the circle constant Tau. In
consequence of this, the decimal representation of a circle constant never ends in
there decimal places having a infinite number of places, nor enters a permanently
repeating pattern in the decimal places. The circle constant is also a not algebraic
transcendental number.

Over the centuries scientists developed formulas for approximating the circle
constant Pi. Chudnovsky's formula is one of them. A algorithm based on Chudnovsky's
formula can be used to calculate an approximation for Pi and also for Tau. The
advantage of the Chudnovsky formula is the good convergence. In contradiction 
the convergence of the Leibniz formula is quit bad.      

The challenge in providing an algorithm for the circle constant is that all decimal
places must be correct in terms of the formula. Based on the desired decimal place
number or precision, the number of places must be correct. The provided algorithm 
takes care of this. At the moment the result of the implemented algorithm was checkt
against the known decimal places of Pi up to 10000 places.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE CONTRIBUTING.md
%perl_vendor_privlib/C*

%changelog
