%define module_name Control-CLI-Extreme
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Control/CLI.pm) perl(IO/Interactive.pm) perl(Module/Build.pm) perl(Net/Telnet.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.13
Release: alt1
Summary: Interact with CLI of Extreme Networking products over any of Telnet, SSH or Serial port
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LS/LSTEVENS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Control::CLI::Extreme is a sub-class of Control::CLI allowing CLI interaction customized for Extreme (including ex-Avaya/ex Nortel Enterprise) Networking products over any of Telnet, SSH or Serial port. It is a drop in replacement for the Control::CLI::AvayaData module following the transfer of the Avaya Data business unit to Extreme Networks.
This class supports all of Extreme Summit, Virtual Services Platform (VSP), Private Label Switches (APLS DSG BoxTypes), Ethernet Routing Switch (ERS) and ex-Nortel Enterprise (Bay Networks heritage) platforms. Currently supported devices:

=over 2

=item *

XOS Summit switches

=item *

VSP 4000, 7000, 7200, 8000, 9000

=item *

APLS DSG models 6248, 7648, 7480, 8032, 9032

=item *

ERS/Passport models 1600, 8300, 8600, 8800

=item *

ERS models 2500, 3x00, 4x00, 5x00

=item *

SR models 2330, 4134

=item *

WLAN 91xx

=item *

WLAN(WC) 81x0

=item *

WLAN(WSS) 2350, 236x, 238x

=item *

BPS 2000, ES 460, ES 470

=item *

Baystack models 325, 425

=item *

Accelar/Passport models 1000, 1100, 1200

=back

The devices supported by this module can have an inconsistent CLI (in terms of syntax, login sequences, terminal width-length-paging, prompts) and in some cases two separate CLI syntaxes are available on the same product.
This class is written so that all the above products can be CLI scripted in a consistent way regardless of their underlying CLI variants. The CLI commands themselves might still vary across the different products though, even here, for certain common functions (like entering privExec mode or disabling terminal more paging) a generic method is provided by this class.

Control::CLI::Extreme is a sub-class of Control::CLI (which is required) and therefore the above functionality can also be performed in a consistent manner regardless of the underlying connection type which can be any of Telnet, SSH or Serial port connection. For SSH, only SSHv2 is supported with either password or publickey authentication.
Furthermore this module leverages the non-blo...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/C*

%changelog
