%define module_name Convert-Base91
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(XSLoader.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000
Release: alt4
Summary: XS base91 encoding/decoding
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{version}.tar.gz

%description
Base91 is a method for encoding binary data as printable ASCII
characters. Every two base91 characters (16 bits) encode 13 or 14 bits
of actual data, thus the overhead is between 14%% and 23%%, an
improvement over base64's overhead of 33%%.

This module provides a procedural interface for encoding/decoding
whole strings and an OO interface for encoding/decoding in chunks.

The `encode_base91' and `decode_base91' functions are available for
export, but are not exported by default.

=over

=item encode_base91 $binary_data

Takes a string containing arbitrary bytes and returns the
base91 encoded data.

=item decode_base91 $base91_data

Takes a string containing base91 encoded data and returns the decoded
string of arbitrary bytes.

=item Convert::Base91->new

Create a new `Convert::Base91' object to keep the state for a chunk
encoding/decoding operation.

=item $base91->encode($data)

Submit the next chunk of arbitrary binary data to be encoded. Returns
nothing.

=item $base91->encode_end

Signals that all chunks of data to be encoded have been submitted.
Returns the base91 encoded data, and clears the state of the $base91
object so it may be used again (for either encoding or decoding).

=item $base91->decode($data)

Submit the next chunk of base91 data to be decoded. Returns nothing.

=item $base91->decode_end

Signals that all chunks of data to be decoded have been submitted.
Returns the decoded data, and clears the state of the $base91 object
so it may be used again (for either encoding or decoding).

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/C*
%perl_vendor_autolib/*

%changelog
