%define module_name Cookie
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(APR/Const.pm) perl(APR/Pool.pm) perl(APR/Request/Apache2.pm) perl(APR/Request/Cookie.pm) perl(APR/Table.pm) perl(APR/URI.pm) perl(Apache/Test.pm) perl(Apache2/Connection.pm) perl(Apache2/Const.pm) perl(Apache2/Log.pm) perl(Apache2/RequestIO.pm) perl(Apache2/RequestRec.pm) perl(Apache2/RequestUtil.pm) perl(Apache2/ServerUtil.pm) perl(Bytes/Random/Secure.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Data/Dump.pm) perl(DateTime.pm) perl(DateTime/Format/Strptime.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Which.pm) perl(HTTP/Request.pm) perl(HTTP/Response.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Module/Generic.pm) perl(Module/Signature.pm) perl(Net/IDN/Encode.pm) perl(Scalar/Util.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/Prereq.pm) perl(Test/Time.pm)
BuildRequires: perl(URI/Escape.pm) perl(Wanted.pm) perl(constant.pm) perl(lib.pm) perl(open.pm) perl(overload.pm) perl(overloading.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(vars.pm) perl(version.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.3.9
Release: alt1
Summary: Cookie Object
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JD/JDEGUEST/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This is a powerful and versatile package to create and represent a cookie compliant with the latest standard as set by rfc6265. This can be used as a standalone module, or can be managed as part of the cookie jar the Cookie::Jar manpage

The object is overloaded and will call the as_string entry elsewhere in this document upon stringification and can also be used in comparison with other cookie object:

    if( $cookie1 eq $cookie2 )
    {
        # do something
    }

This module does not die upon error, but instead returns `undef' and sets an eror, so you should always check the return value of a method.

See also the the Cookie::Jar manpage package to manage server and client side handling of cookies:

    use Cookie::Jar;
    # Possibly passing the cookie repository the Apache2::RequestRec object
    my $jar = Cookie::Jar->new( $r );
    my $c = $jar->make(
        name => 'my_cookie',
        value => 'some value',
        domain => 'example.org',
        path => '/',
        secure => 1,
        http_only => 1,
    ) || die( $jar->error );
    # Set it in the server response `Set-Cookie' header:
    $jar->set( $c ) || die( $jar->error );

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE CONTRIBUTING.md CHANGES README.md
%perl_vendor_privlib/C*

%changelog
